/*==============================================================*/
/* Nom de SGBD :  MySQL 5.0                                     */
/* Date de cration :  31/03/2015 22:18:31                      */
/*==============================================================*/


drop table if exists cause_deces;

drop table if exists cond_immuno_sup;

drop table if exists cote;

drop table if exists donneur;

drop table if exists donneur_decede;

drop table if exists donneur_groupe_hla;

drop table if exists donneur_serologie;

drop table if exists donneur_vivant;

drop table if exists fin_fonction_greffon;

drop table if exists greffe;

drop table if exists greffe_cond_immuno_supp;

drop table if exists greffe_incompatibilite_hla;

drop table if exists groupe_hla;

drop table if exists liquide_perfusion;

drop table if exists parente;

drop table if exists rang_valeur_hla;

drop table if exists risque_immuno;

drop table if exists serologie;

drop table if exists statut_serologie;

drop table if exists statut_virologique;

drop table if exists type_donneur_decede;

drop table if exists val_incompatibilite_hla;

drop table if exists valeur_statut_viro;

drop table if exists virus;

drop table if exists voie_abord;

/*==============================================================*/
/* Table : cause_deces                                          */
/*==============================================================*/
create table cause_deces
(
   cad_code             smallint not null,
   cad_libelle          varchar(50) not null,
   primary key (cad_code)
);

/*==============================================================*/
/* Table : cond_immuno_sup                                      */
/*==============================================================*/
create table cond_immuno_sup
(
   cis_code             numeric(2) not null,
   cis_libelle          varchar(100) not null,
   primary key (cis_code)
);

/*==============================================================*/
/* Table : cote                                                 */
/*==============================================================*/
create table cote
(
   cot_code             numeric(1) not null,
   cot_libelle          varchar(20) not null,
   primary key (cot_code)
);

/*==============================================================*/
/* Table : donneur                                              */
/*==============================================================*/
create table donneur
(
   gre_code             smallint not null,
   gsa_code             smallint not null,
   lip_code             numeric(2) not null,
   cot_code             numeric(1) not null,
   don_numero_cristal   numeric(10) not null,
   don_sexe             numeric(1) not null,
   don_age              numeric(3),
   don_taille           numeric(3),
   don_poids            numeric(3),
   don_comment_dosage   varchar(500),
   don_comment          varchar(500),
   don_chir             varchar(100),
   don_date_clamp       datetime,
   don_comment_prelev   varchar(500),
   don_comment_rein     varchar(500),
   don_princ            int,
   don_pol_sup          int,
   don_pol_inf          int,
   don_veine            int,
   don_veine_comment    varchar(500),
   don_mach_perf        bool,
   don_comment_veine    varchar(500),
   primary key (gre_code)
);

/*==============================================================*/
/* Table : donneur_decede                                       */
/*==============================================================*/
create table donneur_decede
(
   gre_code             smallint not null,
   cad_code             smallint,
   tdd_code             numeric(1) not null,
   lip_code             numeric(2),
   dod_ville            varchar(100) not null,
   dod_comment_deces    varchar(500),
   dod_crit_etendus     bool,
   dod_arret_coeur      bool,
   dod_duree_arret_coeur int,
   dod_pa_moyen         int,
   dod_amines           bool,
   dod_transfusion      bool,
   don_cgr              numeric(2),
   don_cpa              numeric(2),
   don_pfc              numeric(2),
   don_creat_arrivee    numeric(3),
   don_creat_prelev     numeric(3),
   don_dfg              numeric(4),
   don_athe_aorte       bool,
   don_plaq_aorte       bool,
   don_athe_ostium      bool,
   don_plaq_ostium      bool,
   don_athe_artere_rein bool,
   don_plaq_artere_rein bool,
   don_uretere          bool,
   don_plaies_digest    bool,
   don_infect_liquide   bool,
   don_comment_infect_liquide varchar(500),
   primary key (gre_code)
);

/*==============================================================*/
/* Table : donneur_groupe_hla                                   */
/*==============================================================*/
create table donneur_groupe_hla
(
   gre_code             smallint not null,
   hla_code             numeric(2) not null,
   rvh_code             numeric(1) not null,
   dgh_valeur           numeric(3) not null,
   primary key (gre_code, hla_code, rvh_code)
);

/*==============================================================*/
/* Table : donneur_serologie                                    */
/*==============================================================*/
create table donneur_serologie
(
   gre_code             smallint not null,
   ser_code             numeric(2) not null,
   sts_code             numeric(2) not null,
   primary key (gre_code, ser_code, sts_code)
);

/*==============================================================*/
/* Table : donneur_vivant                                       */
/*==============================================================*/
create table donneur_vivant
(
   gre_code             smallint not null,
   voa_code             numeric(1) not null,
   par_code             numeric(2) not null,
   dov_nom              varchar(50) not null,
   dov_prenom           varchar(50) not null,
   dov_lien_parent      varchar(50) not null,
   dov_comment_lien_parent varchar(200),
   dov_imc              numeric(4,2) not null,
   dov_creat            int,
   dov_clair_calc       numeric(4,2),
   dov_clair_iso        numeric(4,2),
   dov_comment_clair    varchar(500),
   dov_proteonurie      numeric(4,2),
   dov_robot            bool,
   primary key (gre_code)
);

/*==============================================================*/
/* Table : fin_fonction_greffon                                 */
/*==============================================================*/
create table fin_fonction_greffon
(
   ffg_code             smallint not null,
   ffg_libelle          varchar(100) not null,
   primary key (ffg_code)
);

/*==============================================================*/
/* Table : greffe                                               */
/*==============================================================*/
create table greffe
(
   gre_code             smallint not null,
   tgr_code             tinyint(2) not null,
   rim_code             numeric(1) not null,
   ffg_code             smallint not null,
   per_code             numeric(7) not null,
   cot_code             numeric(1) not null,
   gre_date             date not null,
   gre_rang             numeric(2) not null,
   gre_greffon_fonct    bool not null,
   gre_date_fin_fnc     date not null,
   gre_chir             varchar(50) not null,
   gre_declampage       datetime not null,
   gre_en               varchar(2) not null,
   gre_isch_totale      time not null,
   gre_duree_anasto     time not null,
   gre_sonde_jj         bool not null,
   gre_comment_greffe   varchar(500),
   gre_lieu_greffe      varchar(500),
   gre_protocole        varchar(200),
   gre_comment_protocole varchar(500),
   gre_dialyse          bool not null,
   gre_dt_der_dialyse   date,
   gre_comment_risq_immuno varchar(500),
   gre_comment_cis      varchar(500),
   primary key (gre_code)
);

/*==============================================================*/
/* Table : greffe_cond_immuno_supp                              */
/*==============================================================*/
create table greffe_cond_immuno_supp
(
   gre_code             smallint not null,
   cis_code             numeric(2) not null,
   primary key (gre_code, cis_code)
);

/*==============================================================*/
/* Table : greffe_incompatibilite_hla                           */
/*==============================================================*/
create table greffe_incompatibilite_hla
(
   hla_code             numeric(2) not null,
   gre_code             smallint not null,
   vih_code             numeric(1) not null,
   primary key (hla_code, gre_code, vih_code)
);

/*==============================================================*/
/* Table : groupe_hla                                           */
/*==============================================================*/
create table groupe_hla
(
   hla_code             numeric(2) not null,
   hla_libelle          varchar(10) not null,
   primary key (hla_code)
);

/*==============================================================*/
/* Table : liquide_perfusion                                    */
/*==============================================================*/
create table liquide_perfusion
(
   lip_code             numeric(2) not null,
   lip_libelle          varchar(100) not null,
   primary key (lip_code)
);

/*==============================================================*/
/* Table : parente                                              */
/*==============================================================*/
create table parente
(
   par_code             numeric(2) not null,
   par_libelle          varchar(50) not null,
   primary key (par_code)
);

/*==============================================================*/
/* Table : rang_valeur_hla                                      */
/*==============================================================*/
create table rang_valeur_hla
(
   rvh_code             numeric(1) not null,
   rvh_libelle          numeric(1) not null,
   primary key (rvh_code)
);

/*==============================================================*/
/* Table : risque_immuno                                        */
/*==============================================================*/
create table risque_immuno
(
   rim_code             numeric(1) not null,
   rim_libelle          varchar(50) not null,
   primary key (rim_code)
);

/*==============================================================*/
/* Table : serologie                                            */
/*==============================================================*/
create table serologie
(
   ser_code             numeric(2) not null,
   ser_libelle          varchar(20) not null,
   primary key (ser_code)
);

/*==============================================================*/
/* Table : statut_serologie                                     */
/*==============================================================*/
create table statut_serologie
(
   sts_code             numeric(2) not null,
   sts_libelle          varchar(50) not null,
   primary key (sts_code)
);

/*==============================================================*/
/* Table : statut_virologique                                   */
/*==============================================================*/
create table statut_virologique
(
   svi_code             numeric(2) not null,
   svi_libelle          varchar(20) not null,
   primary key (svi_code)
);

/*==============================================================*/
/* Table : type_donneur_decede                                  */
/*==============================================================*/
create table type_donneur_decede
(
   tdd_code             numeric(1) not null,
   tdd_libelle          varchar(50) not null,
   primary key (tdd_code)
);

/*==============================================================*/
/* Table : val_incompatibilite_hla                              */
/*==============================================================*/
create table val_incompatibilite_hla
(
   vih_code             numeric(1) not null,
   vih_libelle          varchar(50) not null,
   primary key (vih_code)
);

/*==============================================================*/
/* Table : valeur_statut_viro                                   */
/*==============================================================*/
create table valeur_statut_viro
(
   gre_code             smallint not null,
   svi_code             numeric(2) not null,
   vir_code             numeric(2) not null,
   primary key (gre_code, svi_code, vir_code)
);

/*==============================================================*/
/* Table : virus                                                */
/*==============================================================*/
create table virus
(
   vir_code             numeric(2) not null,
   vir_libelle          varchar(20) not null,
   primary key (vir_code)
);

/*==============================================================*/
/* Table : voie_abord                                           */
/*==============================================================*/
create table voie_abord
(
   voa_code             numeric(1) not null,
   voa_libelle          varchar(50) not null,
   primary key (voa_code)
);

alter table donneur add constraint fk_donneur_cote_preleve foreign key (cot_code)
      references cote (cot_code) on delete restrict on update restrict;

alter table donneur add constraint fk_donneur_groupe_sanguin foreign key (gsa_code)
      references groupe_sanguin (gsa_code) on delete restrict on update restrict;

alter table donneur add constraint fk_donneur_liquide_perf foreign key (lip_code)
      references liquide_perfusion (lip_code) on delete restrict on update restrict;

alter table donneur_decede add constraint fk_donneur_cause_deces foreign key (cad_code)
      references cause_deces (cad_code) on delete restrict on update restrict;

alter table donneur_decede add constraint fk_donneur_dcd_type_donneur_dcd foreign key (tdd_code)
      references type_donneur_decede (tdd_code) on delete restrict on update restrict;

alter table donneur_decede add constraint fk_donneur_decede_donneur foreign key (gre_code)
      references donneur (gre_code) on delete restrict on update restrict;

alter table donneur_decede add constraint fk_donneur_decede_liq_conserv foreign key (lip_code)
      references liquide_perfusion (lip_code) on delete restrict on update restrict;

alter table donneur_groupe_hla add constraint fk_donneur_groupage_hla_don foreign key (gre_code)
      references donneur (gre_code) on delete restrict on update restrict;

alter table donneur_groupe_hla add constraint fk_donneur_groupe_hla_group foreign key (hla_code)
      references groupe_hla (hla_code) on delete restrict on update restrict;

alter table donneur_groupe_hla add constraint fk_donneur_groupe_hla_rang foreign key (rvh_code)
      references rang_valeur_hla (rvh_code) on delete restrict on update restrict;

alter table donneur_serologie add constraint fk_donneur_serologie_donneu foreign key (gre_code)
      references donneur (gre_code) on delete restrict on update restrict;

alter table donneur_serologie add constraint fk_donneur_serologie_serolo foreign key (ser_code)
      references serologie (ser_code) on delete restrict on update restrict;

alter table donneur_serologie add constraint fk_donneur_serologie_stat_s foreign key (sts_code)
      references statut_serologie (sts_code) on delete restrict on update restrict;

alter table donneur_vivant add constraint fk_donneur_vivant_donneur foreign key (gre_code)
      references donneur (gre_code) on delete restrict on update restrict;

alter table donneur_vivant add constraint fk_donneur_vivant_parente foreign key (par_code)
      references parente (par_code) on delete restrict on update restrict;

alter table donneur_vivant add constraint fk_donneur_vivant_voie_abor foreign key (voa_code)
      references voie_abord (voa_code) on delete restrict on update restrict;

alter table greffe add constraint fk_donneur_greffe foreign key (gre_code)
      references donneur (gre_code) on delete restrict on update restrict;

alter table greffe add constraint fk_greffe_cote_transplant foreign key (cot_code)
      references cote (cot_code) on delete restrict on update restrict;

alter table greffe add constraint fk_greffe_fin_fonction_gref foreign key (ffg_code)
      references fin_fonction_greffon (ffg_code) on delete restrict on update restrict;

alter table greffe add constraint fk_greffe_risque_immuno_hla foreign key (rim_hla_code)
      references risque_immuno_hla (rim_hla_code) on delete restrict on update restrict;

alter table greffe add constraint fk_greffe_risque_immuno_abo foreign key (rim_abo_code)
      references risque_immuno_abo (rim_abo_code) on delete restrict on update restrict;
      
alter table greffe add constraint fk_greffe_type_greffe foreign key (tgr_code)
      references type_greffe (tgr_code) on delete restrict on update restrict;

alter table greffe_cond_immuno_supp add constraint fk_greffe_cond_immuno_supp_ foreign key (cis_code)
      references cond_immuno_sup (cis_code) on delete restrict on update restrict;

alter table greffe_cond_immuno_supp add constraint fk_greffe_cond_immuno_supp_ foreign key (gre_code)
      references greffe (gre_code) on delete restrict on update restrict;

alter table greffe_incompatibilite_hla add constraint fk_greffe_incompatib_hla_gr foreign key (gre_code)
      references greffe (gre_code) on delete restrict on update restrict;

alter table greffe_incompatibilite_hla add constraint fk_greffe_incompatib_hla_gr foreign key (hla_code)
      references groupe_hla (hla_code) on delete restrict on update restrict;

alter table greffe_incompatibilite_hla add constraint fk_greffe_incompatib_hla_va foreign key (vih_code)
      references val_incompatibilite_hla (vih_code) on delete restrict on update restrict;

alter table valeur_statut_viro add constraint fk_valeur_statut_viro_greffe foreign key (gre_code)
      references greffe (gre_code) on delete restrict on update restrict;

alter table valeur_statut_viro add constraint fk_valeur_statut_viro_statut_viro foreign key (svi_code)
      references statut_virologique (svi_code) on delete restrict on update restrict;

alter table valeur_statut_viro add constraint fk_valeur_statut_viro_virus foreign key (vir_code)
      references virus (vir_code) on delete restrict on update restrict;

